//
//  RTBFileHandler.m
//  RoadTripBingo
//
//  Created by Juan Navas Martin on 4/27/14.
//  Copyright (c) 2014 Juan Navas. All rights reserved.
//

#import "RTBFileHandler.h"

@implementation RTBFileHandler

+ (void)removeImage:(NSString *)fileName
{
    NSFileManager *fileManager = [NSFileManager defaultManager];
    NSString *homePath = NSHomeDirectory();
    NSString *userSignsDirectory = [homePath stringByAppendingPathComponent:@"/Documents/userSigns"];
    
    NSString *filePath = [userSignsDirectory stringByAppendingPathComponent:fileName];
    NSError *error;
    BOOL success = [fileManager removeItemAtPath:filePath error:&error];
    if (success) {
        NSLog(@"UserPicture: %@ removed correctly!", fileName);
    }
    else
    {
        NSLog(@"Could not delete file '%@' -:%@ ", fileName, [error localizedDescription]);
    }
}
+ (BOOL) checkOrCreateFolder: (NSString *)path {
    
    BOOL isDir, success = NO;
    NSError *error = Nil;
    
    NSFileManager *fileManager= [NSFileManager defaultManager];
    if(![fileManager fileExistsAtPath:path isDirectory:&isDir])
    {
        if(![fileManager createDirectoryAtPath:path withIntermediateDirectories:YES attributes:Nil error:&error]){
            NSLog(@"Error: Create folder failed %@\nERROR: %@", path, error);
            success = NO;
            
        }
        else {
            NSLog(@"Success: Create folder success %@", path);
            success = YES;
        }
        
    } else {
        NSLog(@"\nFolder Exists!! %@",path);
        success = YES;
    }
    return success;
}
//Returns an image with a given fileName, from the app directory
+ (UIImage*)loadImageWithName: (NSString *) fileName
{
    NSString *homePath = NSHomeDirectory();
    NSString* path = [homePath stringByAppendingPathComponent:
                      [NSString stringWithFormat:@"/Documents/userSigns/%@",fileName]];
    UIImage* image = [UIImage imageWithContentsOfFile:path];
    return image;
}


//Saves a given image to the app directory, with the given filename
+ (BOOL)saveImage: (UIImage*)image withFileName: (NSString *)fileName
{
    if (image != nil)
    {
        NSString *homePath = NSHomeDirectory();
        NSString *userSignsDirectory = [homePath stringByAppendingPathComponent:@"/Documents/userSigns"];

        if ([self checkOrCreateFolder:userSignsDirectory]) {
            NSString* userImageFilePath = [userSignsDirectory stringByAppendingPathComponent:fileName];

            NSData *data = UIImagePNGRepresentation(image);
            [data writeToFile:userImageFilePath atomically:YES];
            return true;
        }
        else return FALSE;
    } else return FALSE;
}



@end
